#ifndef _SPI_CONFIG_H
#define _SPI_CONFIG_H
 
#define BUS_CLK 20000     //20000KHz = 20 MHz
/*Selects the port for pins of SPI1*/
#define SPI1_Pins_PortC 1            //pin C0:MOSI1  pin C1:MISO1 
                                     //pin C2:SCLK1  pin C3:SS1

#define SPI1_Pins_PortG 0            //pin G0:MOSI1  pin G1:MISO1 
                                     //pin G2:SCLK1  pin G3:SS1

#if ( (SPI1_Pins_PortC && SPI1_Pins_PortG) || !(SPI1_Pins_PortC || SPI1_Pins_PortG))
  #error "error SPI1_Port"           //error if both the ports are defined 1 or 0
#endif

/*Selects the port for pins of SPI2*/ 
#define SPI2_Pins_PortA 1            //pin A0:MOSI2  pin A1:MISO2 
                                     //pin A2:SCLK2  pin A3:SS2

#define SPI2_Pins_PortD 0            //pin D0:MOSI2  pin D1:MISO2 
                                     //pin D2:SCLK2  pin D3:SS2

#if ( (SPI2_Pins_PortA && SPI2_Pins_PortD) || !(SPI2_Pins_PortA || SPI2_Pins_PortD))
  #error "error SPI2_Port"           //error if both the ports are defined 1 or 0
#endif



#endif